const { __ } = wp.i18n;

const i18n = {};

i18n.COMMON = {
  PLUGIN_NAME: __( 'Media File Renamer', 'media-file-renamer' ),
  TUTORIAL: __( 'Tutorial', 'media-file-renamer' ),
  SETTINGS: __( 'Settings', 'media-file-renamer' ),
  DASHBOARD: __( 'Dashboard', 'media-file-renamer' ),
  BY_JORDY_MEOW: __( 'By Jordy Meow', 'media-file-renamer' ),
};

i18n.DASHBOARD = {
  NONE: __( 'None', 'media-file-renamer' ),
  AUTO_ATTACH_ALL_MESSAGE: __( 'All your posts, pages, products (and other post types) will be scanned, and if images are used in them, they will be attached. Currently, Featured Images and Product Galleries are supported.', 'media-file-renamer' ),
  AUTO_ATTACH_SELECTED_MESSAGE: __( 'All your posts, pages, products (and other post types) will be scanned, and if selected images are used in them, they will be attached. Currently, Featured Images and Product Galleries are supported.', 'media-file-renamer' ),
  AUTO_ATTACH_MESSAGE_MEDIA_CLEANER: __( '⚠️ You should first run a scan using <a href="https://meowapps.com/media-cleaner/" target="_blank">Media Cleaner</a> to create all your media references. Otherwise, the auto-attach feature will not work properly.', 'media-file-renamer' ),
  FEATURE_REQUIRED_PRO: __( 'This feature is only available in the Pro version.', 'media-file-renamer' ),
  GET_PRO_VERSION: __( 'Get the Pro Version', 'media-file-renamer' ),
  READ_TUTORIAL: __( 'Read the tutorial', 'media-file-renamer' ),
  FREE_VERSION_INSTRUCTION: __( "You must <b>backup the uploads folder and DB</b> before using the Renamer. If you don't know how, give a try to <a target='_blank' href='https://meow.click/blogvault'>BlogVault</a>. It is also highly recommanded to read the tutorial. Last but not least, check the <b>Pro Version</b>, as it adds many features and also supports the development. This message is only displayed in the free version. Thank you!", 'media-file-renamer' ),
  MODE: __( 'Mode', 'media-file-renamer' ),
  RENAME: __( 'Rename', 'media-file-renamer' ),
  MOVE: __( 'Move', 'media-file-renamer' ),
  EDIT_MEDIA: __( 'Edit Media', 'media-file-renamer' ),
  ANALYZE_LIBRARY: __( 'Analyze Library', 'media-file-renamer' ),
  AUTO_ATTACH_ALL: __( 'Auto-Attach All Media Entries', 'media-file-renamer' ),
  AUTO_ATTACH_SELECTED: __( 'Auto-Attach Selected Media Entries', 'media-file-renamer' ),
  LOCK_ALL: __( "Lock <strong>All</strong>", 'media-file-renamer' ),
  TOGGLE_LOCK_SELECTED: __( "Toggle Lock&nbsp;<strong>{0}</strong>&nbsp;Entries", 'media-file-renamer' ),
  UNLOCK_ALL: __( "Unlock <strong>All</strong>", 'media-file-renamer' ),
  RENAME_ALL: __( "Rename <strong>All</strong>", 'media-file-renamer' ),
  UNDO_ALL: __( "Undo <strong>All</strong>", 'media-file-renamer' ),
  RENAME_SELECTED: __( "Rename&nbsp;<strong>{0}</strong>&nbsp;Entries", 'media-file-renamer' ),
  MOVE_SELECTED: __( "Move&nbsp;<strong>{0}</strong>&nbsp;Entries", 'media-file-renamer' ),
  UNDO_SELECTED: __( "Undo&nbsp;<strong>{0}</strong>&nbsp;Entries", 'media-file-renamer' ),
  UNLOCK_SELECTED: __( "Unlock&nbsp;<strong>{0}</strong>&nbsp;Entries", 'media-file-renamer' ),
  LOCK_SELECTED: __( "Lock&nbsp;<strong>{0}</strong>&nbsp;Entries", 'media-file-renamer' ),
  SYNC_SELECTED: __( "Sync&nbsp;<strong>{0}</strong>&nbsp;Entries", 'media-file-renamer' ),
  SYNC_SELECTED_AI: __( "Sync AI Vision&nbsp;<strong>{0}</strong>&nbsp;Entries", 'media-file-renamer' ),
  SYNC_FIELDS: __( 'Sync Fields', 'media-file-renamer' ),
  SYNC: __( 'Sync', 'media-file-renamer' ),
  SYNCED: __( 'Synced', 'media-file-renamer' ),
  PENDING: __( 'Pending', 'media-file-renamer' ),
  RENAMED: __( 'Renamed', 'media-file-renamer' ),
  NEVER_RENAMED: __( 'Never Renamed', 'media-file-renamer' ),
  LOCKED: __( 'Locked', 'media-file-renamer' ),
  LOCK: __( 'Lock', 'media-file-renamer' ),
  UNLOCKED: __( 'Unlocked', 'media-file-renamer' ),
  ALL: __( 'All', 'media-file-renamer' ),
  THUMBNAIL: __( 'Thumbnail', 'media-file-renamer' ),
  FILENAME_METADATA: __( 'Filename & Metadata', 'media-file-renamer' ),
  TITLE: __( 'Title', 'media-file-renamer' ),
  ALT_TEXT: __( 'ALT Text', 'media-file-renamer' ),
  DESCRIPTION: __( 'Description', 'media-file-renamer' ),
  FILENAME: __( 'Filename', 'media-file-renamer' ),
  CAPTION: __( 'Caption', 'media-file-renamer' ),
  ATTACHED_TO: __( 'Attached To', 'media-file-renamer' ),
  PATH: __( 'Path', 'media-file-renamer' ),
  TABLE_EMPTY_MESSAGE: __( "It's all clean & nice here! 👍<br />Why not trying to give a boost to your database with <a target='_blank' href='https://wordpress.org/plugins/database-cleaner/'>Database Cleaner</a>? 😌", 'media-file-renamer' ),
  ITEMS_PER_PAGE: __( 'items per page', 'media-file-renamer' ),
  HISTORY: __( 'History', 'media-file-renamer' ),
  HISTORY_COLUMNS: {
    FILE: __( 'File', 'media-file-renamer' ),
    ALT: __( 'Alt', 'media-file-renamer' ),
    TITLE: __( 'Title', 'media-file-renamer' ),
    DESCRIPTION: __( 'Description', 'media-file-renamer' ),
    CAPTION: __( 'Caption', 'media-file-renamer' ),
  },
  POST: __( 'Post', 'media-file-renamer' ),
  EDIT: __( 'Edit', 'media-file-renamer' ),
};

i18n.DASHBOARD_FILTERS = {
  NO_TITLE: __( 'No Title', 'media-file-renamer' ),
  NO_ALT_TEXT: __( 'No ALT Text', 'media-file-renamer' ),
  NO_DESCRIPTION: __( 'No Description', 'media-file-renamer' ),
  NO_CAPTION: __( 'No Capiton', 'media-file-renamer' ),
};

i18n.BULK_TASK = {
  FINAL_MESSAGE_WITH_ERROR: __( 'The process has finished, but {0} error(s) occurred (check your console).', 'media-file-renamer' ),
  PREPARING: __( 'Preparing...', 'media-file-renamer' ),
  AUTO_ATTACHING: __( 'Auto attaching...', 'media-file-renamer' ),
  UNDOING: __( 'Undoing...', 'media-file-renamer' ),
  UNDO_MEDIA: __( 'Undo Media', 'media-file-renamer' ),
  ANALYZING: __( 'Analyzing...', 'media-file-renamer' ),
  LOCKING: __( 'Locking...', 'media-file-renamer' ),
  UNLOCKING: __( 'Unlocking...', 'media-file-renamer' ),
  RENAMING: __( 'Renaming', 'media-file-renamer' ),
  SYNCING_MEDIA: __( 'Syncing Media', 'media-file-renamer' ),
  MOVE_ERROR: __( 'Please check the files at least 1 file you would like to move in bulk.', 'media-file-renamer' ),
  MOVING: __( 'Moving', 'media-file-renamer' ),
};

i18n.CONTEXT = {
  UPDATING: __( 'Updating...', 'media-file-renamer' ),
  MODAL_DOES_NOT_EXIST: __( "The modal {0} doesn't exist.", 'media-file-renamer' ),
  FAILED_TO_MOVE: __( 'Failed to move the folder/gallery.', 'media-file-renamer' ),
};

i18n.RENAMER_FIELDS = {

  AUTO_RENAME_HOVER_NONE: __( 'No methods are selected, the filename will be sanitize and use custom filters and rules you have set up.', 'media-file-renamer' ),
  AUTO_RENAME_HOVER_MEDIA_TITLE: __( 'Rename based on the media title.', 'media-file-renamer' ),
  AUTO_RENAME_HOVER_POST_TITLE: __( 'Rename based on the post title.', 'media-file-renamer' ),
  AUTO_RENAME_HOVER_POST_ACF_FIELD: __( 'Rename based on a custom field from ACF.', 'media-file-renamer' ),
  AUTO_RENAME_HOVER_VISION: __( 'Use AI vision to analyze the image and generate a filename.', 'media-file-renamer' ),
  AUTO_RENAME_HOVER_ALT_TEXT: __( 'Rename based on the alt text metadata.', 'media-file-renamer' ),
  AUTO_RENAME_HOVER_ANONYMIZE_MD5: __( 'Rename by generating an MD5 hash to anonymize the filename.', 'media-file-renamer' ),


  UNLOCK_DESCRIPTION: __( 'Unlock, to allow future actions', 'media-file-renamer' ),
  LOCK_DESCRIPTION: __( 'Lock, to avoid future actions', 'media-file-renamer' ),
  FILENAME_ALREADY_EXISTS: __( "The filename proposed by {0} already exists. Automatically switched to {1}.", 'media-file-renamer' ),
  FILENAME_ALREADY_EXISTS_NO_SKIP: __( "The filename proposed by {0} already exists. Please select another method, rename manually or enable Advanced > Unique Filenames to always get a unique filename.", 'media-file-renamer' ),
  ROLLBACK_TO_ORIGINAL: __( 'Back to original filename.', 'media-file-renamer' ),
  RENAME_AUTOMATICALLY: __( 'Rename automatically', 'media-file-renamer' ),
  AUTO_RENAME: __( 'AUTO', 'media-file-renamer' ),
  AUTO_RENAME_ALREADY_MATCHING: __( 'The filename is already matching the auto method result, no need to auto rename.', 'media-file-renamer' ),
  RENAME_MANUALLY: __( 'Rename manually', 'media-file-renamer' ),
  CANCEL_MANUAL_RENAME: __( 'Cancel manual rename', 'media-file-renamer' ),
  CANCEL: __( 'Cancel', 'media-file-renamer' ),
  APPLY: __( 'Apply', 'media-file-renamer' ),
  MOVE: __( 'Move', 'media-file-renamer' ),


  AI_SUGGEST_ALL_METADATA_TOOLTIP: __( 'Suggest all metadata fields based on the image content.', 'media-file-renamer' ),
  AI_SUGGEST_FILENAME: __( 'Suggest a filename based on the image content.', 'media-file-renamer' ),

};

i18n.MODAL = {
  RUN: __( 'Run', 'media-file-renamer' ),
  I_NEED_PRO_VERSION: __( 'I need the Pro Version', 'media-file-renamer' ),
  CLOSE: __( 'Close', 'media-file-renamer' ),
  UNDERSTAND: __( 'I understand', 'media-file-renamer' ),
  GO_TO_SETTINGS: __( 'Go to Settings', 'media-file-renamer' ),
  ERROR: __( 'Error', 'media-file-renamer' ),
  ERROR_WITH_MEDIA: __( 'Error with Media', 'media-file-renamer' ),
  AUTO_RETRY: __( 'Auto Retry', 'media-file-renamer' ),
  AUTO_SKIP: __( 'Auto Skip', 'media-file-renamer' ),
  RETRY: __( 'Retry', 'media-file-renamer' ),
  SKIP: __( 'Skip', 'media-file-renamer' ),
  STOP: __( 'Stop', 'media-file-renamer' ),
  AUTO_RETRY_DESCRIPTION: __( '<b>Auto Retry</b> will retry the actions up to 10 times. It will increase the delay at every try to avoid timeouts. <b>Auto Skip</b> will simply skip the failed action.', 'media-file-renamer' ),
  MOVE_ALL_TITLE: __( 'Move selected {0} Entries', 'media-file-renamer' ),
  MOVE_ALL_CONTENT: __( 'Where would you like to move these files (in the /uploads directory)?', 'media-file-renamer' ),
  SELECTABLE_FOLDERS: __( 'Selectable folders', 'media-file-renamer' ),
  FORCE_REFRESH_DIRECTORIES: __( 'Refresh', 'media-file-renamer' ),
  SELECTABLE_FOLDERS_REQUIRED_PRO: __( 'This feature only for Pro users. If you are pro user, you can go through the folders.', 'media-file-renamer' ),
  AUTO_ATTACH_TITLE: __( 'Automatically attach your images to your posts', 'media-file-renamer' ),
  RENAME_ALL_TITLE: __( 'You are about to rename all the files in this table', 'media-file-renamer' ),
  RENAME_ALL_CONTENT: __( 'Renaming files is a dangerous operation. Please make sure you made a backup of your entire WordPress install. Should we start?', 'media-file-renamer' ),
  RENAME_ALL_FIELDS: __( 'All the Metadata fields you have enbaled will also be generated by AI Vision.', 'media-file-renamer' ),
  SYNC_FIELDS_TITLE: __( "Synchronize Fields of All Entries", 'media-file-renamer' ),
  SYNC_FILENAME: __( 'Sync with Filename', 'media-file-renamer' ),
  GENERATE_WITH_AI: __( 'Generate with AI Vision', 'media-file-renamer' ),
  SYNC_FIELDS_CONTENT: __( 'You are about to force re-sync the enabled metadata fields for all of your unlocked entries. Are you sure you would like to proceed? All the following fields will be affected:', 'media-file-renamer' ),
  UNDO_ALL_TITLE: __( 'You are about to undo the renaming for all your files', 'media-file-renamer' ),
  UNDO_ALL_CONTENT: __( 'Are you sure you would like to proceed?', 'media-file-renamer' ),
  SUCCESS_TITLE: __( 'Success', 'media-file-renamer' ),
  MOVE_TITLE: __( 'Move this file', 'media-file-renamer' ),
  MOVE_CONTENT: __( 'Where would you like to move this file (in the /uploads directory)?', 'media-file-renamer' ),
  CREATE_FOLDER: __( 'Create Folder', 'media-file-renamer' ),
  EXIT: __( 'Exit', 'media-file-renamer' ),
  RENAME_TITLE: __( 'Rename your media', 'media-file-renamer' ),
  NO_METHOD_SELECTED: __( 'No Auto Method Selected', 'media-file-renamer' ),
  NO_METHOD_SELECTED_CONTENT: __( ' You don\'t have any Auto Rename Method selected. This means that the plugin will only sanitize the current filename or use your custom method if you have one. Go to the Settings to select an Auto Rename Method.', 'media-file-renamer' ),
  SYNC_FIELDS_TIME_FILTER: __( 'Time Filter', 'media-file-renamer' ),
  SYNC_FIELDS_TIME_FILTER_DESCRIPTION: __( 'Only sync the fields that have not been updated since the past selected hours.', 'media-file-renamer' ),
  SYNC_FIELDS_TIME_FILTER_DISABLED: __( 'Time Filter is disabled if you are not using the History feature.', 'media-file-renamer' ),
};

i18n.AUTO_RENAME_OPTIONS = {
  BASED_ON_MEDIA_TITLE: __( 'Based on Media Title', 'media-file-renamer' ),
  MEDIA_TITLE: __( 'Media Title', 'media-file-renamer' ),
  BASED_ON_ATTACHED_POST: __( 'Based on Attached Post (ACF Field)', 'media-file-renamer' ),
  POST_TITLE_ACF: __( 'Attached Post (ACF Field)', 'media-file-renamer' ),
  BASED_ON_ATTACHED_POST_TITLE: __( 'Based on Attached Post (Title)', 'media-file-renamer' ),
  POST_TITLE: __( 'Post Title', 'media-file-renamer' ),
  BASED_ON_ALTERNATIVE_TEXT: __( 'Based on Alternative Text', 'media-file-renamer' ),
  ALT_TEXT: __( 'Alternative Text', 'media-file-renamer' ),
  ANONYMIZE_WITH_MD5: __( 'Anonymize with MD5', 'media-file-renamer' ),
  MD5: __( 'MD5', 'media-file-renamer' ),
  DISABLE_AUTOMATIC_RENAME: __( 'Disable Automatic Rename', 'media-file-renamer' ),
  AI: __( 'AI Vision', 'media-file-renamer' ),
  MANUAL: __( 'Manual', 'media-file-renamer' ),
  NONE: __( 'None', 'media-file-renamer' ),
};

i18n.MEDIA_LIBRARY_FIELD_OPTIONS = {
  NONE: __( 'None', 'media-file-renamer' ),
  FULL: __( 'Rename Field with All Features', 'media-file-renamer' ),
  MODAL: __( 'Rename Button -> Modal', 'media-file-renamer' ),
};

i18n.SETTINGS = {
  DESCRIPTION: __( "It works out of the box, the default settings are good for most installs. However, you should really have a look at the <a href='https://meowapps.com/plugin/media-file-renamer/'>tutorial</a>. If you are a SEO guru or someone who loves having a perfectly neat filesystem, it is recommended to use automatic renaming first, then to tweak specific files with manual renaming. The <a href='/wp-admin/upload.php?page=mfrh_dashboard'>Renamer Dashboard</a> makes it very easy.", 'media-file-renamer' ),
  AUTO: __( 'Auto', 'media-file-renamer' ),
  RESET: __( 'Reset', 'media-file-renamer' ),
  MANUAL: __( 'Manual', 'media-file-renamer' ),
  BASIC: __( 'Basic', 'media-file-renamer' ),
  RENAMING_METHODS: __( 'Renaming Methods', 'media-file-renamer' ),
  METADATA_FIELDS: __( 'Metadata Fields', 'media-file-renamer' ),
  METADATA_FIELDS_HELP: __( 'Modify the metadata directly in the Dashboard, manually or with AI Suggestions.', 'media-file-renamer' ),
  ON_UPLOAD_HELP: __( 'After the upload, the metadata can be updated based on those methods.', 'media-file-renamer' ),
  FEATURES: __( 'Features', 'media-file-renamer' ),
  ADVANCED: __( 'Advanced', 'media-file-renamer' ),
  RENAMING: __( 'Renaming', 'media-file-renamer' ),
  MANUAL_PROMPT: __( 'Manual Prompts', 'media-file-renamer' ),
  MANUAL_PROMPT_FIELD_DESCRIPTION: __( 'Manually change the prompts for the AI suggestions.', 'media-file-renamer' ),
  MANUAL_PROMPT_FILENAME: __( 'Prompt for Filename', 'media-file-renamer' ),
  MANUAL_PROMPT_TITLE: __( 'Prompt for Title', 'media-file-renamer' ),
  MANUAL_PROMPT_DESCRIPTION: __( 'Prompt for Description', 'media-file-renamer' ),
  MANUAL_PROMPT_ALT: __( 'Prompt for ALT Text', 'media-file-renamer' ),
  MANUAL_PROMPT_CAPTION: __( 'Prompt for Caption', 'media-file-renamer' ),
  AI: __('AI', 'media-file-renamer'),
  AI_BASIC: __( 'Basic', 'media-file-renamer' ),
  AI_ADVANCED: __( 'Advanced', 'media-file-renamer' ),
  ALL: __( 'All', 'media-file-renamer' ),
  POST_RENAME_EVENTS: __( 'Sync Fields (Post-Rename Events)', 'media-file-renamer' ),
  FIELDS_SYNCING_DISABLED: __( 'You can not use the Fields Syncing features while the "Trigger on Attachment Update" option is enabled. As the media\'s metadata is being updated, it is going to trigger a rename, which would create an infinite loop of Renaming -> Syncing -> Renaming.', 'media-file-renamer' ),
  FIELDS_SYNCING: __( 'Fields Syncing', 'media-file-renamer' ),
  FIELDS_SYNCING_DESCRIPTION: __( 'The fields in the database will be synchronized, but the data already written in your HTML will not be overwritten.', 'media-file-renamer' ),
  AUTO_LOCK: __( 'Auto Lock', 'media-file-renamer' ),
  PERFORMANCE: __( 'Performance', 'media-file-renamer' ),
  FOR_DEVELOPERS: __( 'For Developers', 'media-file-renamer' ),
  FOR_ADVANCED_USERS_DEVELOPERS: __( 'For Advanced Users & Developers', 'media-file-renamer' ),
  LICENSE_PRO: __( 'License (Pro)', 'media-file-renamer' ),
  LOGS_DEBUG: __( 'Logs & Debug', 'media-file-renamer' ),
  PARSERS: __( 'Parsers', 'media-file-renamer' ),
  SIDE_UPDATES: __( 'Side Updates', 'media-file-renamer' ),
  SIDE_UPDATES_DESCRIPTION: __( "When the files are renamed, many links to them on your WordPress might be broken. Those options are updating the references to those files. <strong>Give it a try, every install is different and it might not work for certain kind of references.</strong>", 'media-file-renamer' ),
  ENABLE: __( 'Enable', 'media-file-renamer' ),
  DISABLE: __( 'Disable', 'media-file-renamer' ),
  DISABLE_PARSER: __( 'Disable Parser', 'media-file-renamer' ),
  AI_ENGINE_SYNC: __( '🤖 When syncing using AI Engine, the plugin will use AI to generate <b>each field</b> you selected individually. This is a very powerful feature, but it might take a bit of time to process.', 'media-file-renamer' ),
  POSTS: __( 'Posts', 'media-file-renamer' ),
  POSTS_DESCRIPTION: __( "Update the references to the renamed files in the <strong>content</strong> of the posts (of all types).", 'media-file-renamer' ),
  EXCERPTS: __( 'Excerpts', 'media-file-renamer' ),
  EXCERPTS_DESCRIPTION: __( "Update the references to the renamed files in the <strong>excerpts</strong> of the posts (of all types).", 'media-file-renamer' ),
  POSTS_META: __( 'Post Meta', 'media-file-renamer' ),
  POSTS_META_DESCRIPTION: __( "Update the references in the <strong>custom fields</strong> of the posts (including pages and custom types metadata).", 'media-file-renamer' ),
  ELEMENTOR: __( 'Elementor', 'media-file-renamer' ),
  ELEMENTOR_DESCRIPTION: __( "Update the references in the <strong>encrypted data</strong> of the posts handled by Elementor. <span>This will probably slow down the renaming extremely and cause timeouts. Test it carefully.</span>", 'media-file-renamer' ),
  AUTO_DESCRIPTION: __( 'The filename will be automatically renamed based on the selected methods. The first method that returns a valid filename will be used. Set all the methods to "None" to create your own Auto renaming method.', 'media-file-renamer' ),
  METHOD: __( 'Method', 'media-file-renamer' ),
  AUTO_RENAME_NONE: __( 'You can now use the <strong>mfrh_new_filename</strong> filter to create your own Auto renaming method. Find some examples <a href="https://meowapps.com/media-file-renamer/issues/#customize-the-filenames" target="_blank">here</a>. You can also go in the "Advanced" tab to create custom rules without coding!', 'media-file-renamer' ),
  METHOD_DESCRIPTION: __( 'Attached Post includes all kinds of Post Types: Posts, Pages, Products, etc.', 'media-file-renamer' ),
  ACF_FIELD_NAME: __( 'ACF Field Name', 'media-file-renamer' ),
  IMAGES_ONLY: __( 'Images Only', 'media-file-renamer' ),
  IMAGES_ONLY_DESCRIPTION: __( 'Restricts the renaming to images and icons. Nothing else will be renamed.', 'media-file-renamer' ),
  FEATURED_ONLY: __( 'Featured Only', 'media-file-renamer' ),
  FEATURED_ONLY_DESCRIPTION: __( 'Restricts the renaming to Featured Images only.', 'media-file-renamer' ),
  ON_UPLOAD: __( 'On Upload', 'media-file-renamer' ),
  ON_UPLOAD_DESCRIPTION_ON_POST_TITLE: __( "Note: The Attached Post Title <u>will not be used</u> at the time of the upload due to WordPress API constraints.", 'media-file-renamer' ),
  SYNC_WITH_FILENAME: __( 'Sync with filename', 'media-file-renamer' ),
  SLUG_PERMALINK: __( 'Slug/Permalink', 'media-file-renamer' ),
  SLUG_PERMALINK_DESCRIPTION: __( 'Better to keep this un-checked as the link might have been referenced somewhere else.', 'media-file-renamer' ),
  TRANSLITERATION: __( 'Transliteration', 'media-file-renamer' ),
  TRANSLITERATION_LABEL: __( 'Enable (Recommended)', 'media-file-renamer' ),
  TRANSLITERATION_DESCRIPTION: __( "Replace accents, emoticons, diacritics, umlauts, cyrillic and any kind of tricky characters by their ASCII equivalent.<br /> <i>Examples: tête &#8594; tete, schön &#8594; schon, Добро &#8594; dobro, etc.</i>", 'media-file-renamer' ),
  UNDO: __( 'Undo', 'media-file-renamer' ),
  UNDO_DESCRIPTION: __( 'An undo icon will be added to the UI. This allows to rollback to the original filename.', 'media-file-renamer' ),
  MOVE: __( 'Move', 'media-file-renamer' ),
  MOVE_DESCRIPTION: __( 'A move button will be added, and will allow you to move a file to another directory.', 'media-file-renamer' ),
  LOCK_DESCRIPTION: __( 'A lock icon will be added, and will allow you to lock a file to avoid future actions.', 'media-file-renamer' ),
  DASHBOARD: __( 'Dashboard', 'media-file-renamer' ),
  RENAME_FIELD: __( 'Rename Field', 'media-file-renamer' ),
  RENAME_FIELD_DESCRIPTION: __( 'An editable field will be added.', 'media-file-renamer' ),
  RENAME_FIELD_PLACE_DESCRIPTION: __( 'An editable field will be added to edit your filenames.', 'media-file-renamer' ),
  AI_SUGGESTIONS: __( 'AI Suggestions', 'media-file-renamer' ),
  AI_SUGGESTIONS_DESCRIPTION: __( 'This will give you suggestions based on what the AI sees in your metadata.', 'media-file-renamer' ),
  AI_VISION: __( 'AI Vision', 'media-file-renamer' ),
  AI_VISION_DISABLED: __( '( Needs AI Suggestions )', 'media-file-renamer' ),
  AI_VISION_DESCRIPTION: __( 'This will analyze your images and give you perfect suggestions based on your images.', 'media-file-renamer' ),
  EXIF_CONTEXT: __( 'EXIF Context', 'media-file-renamer' ),
  EXIF_CONTEXT_DESCRIPTION: __( 'AI Vision will use the EXIF data (title, caption, keywords) to enhance its suggestions.', 'media-file-renamer' ),
  AI_VISION_CACHE: __( 'AI Vision Cache', 'media-file-renamer' ),
  AI_VISION_CACHE_DESCRIPTION: __( 'When AI Vision analysis is cached, completion requests will be prioritized, enhancing speed and reducing API calls.', 'media-file-renamer' ),
  AI_VISION_ON_UPLOAD: __( 'AI Vision On Upload', 'media-file-renamer' ),
  AI_VISION_ON_UPLOAD_DESCRIPTION: __( 'AI Vision suggests refined Titles, Descriptions, and Alt Texts, potentially extending processing times.', 'media-file-renamer' ),
  AI_VISION_ON_UPLOAD_WARNING: __( '⚠️ You already have Clean Uploads enabled, which will overwrite the title, description, and alt text.', 'media-file-renamer' ),
  SANITIZE: __( 'Sanitize', 'media-file-renamer' ),
  SANITIZE_DESCRIPTION: __( 'Everything you type will be sanitized. This way, you can be certain the filename is safe and tidy.', 'media-file-renamer' ),
  FORCE_RENAME: __( 'Force Rename', 'media-file-renamer' ),
  FORCE_RENAME_DESCRIPTION: __( 'Update the references to the file even if the file renaming itself was not successful. You might want to use that option if your install is broken and you are trying to link your Media to files for which the filenames has been altered (after a migration for exemple)', 'media-file-renamer' ),

  UNIQUE_FILENAMES: __( 'Unique Filenames', 'media-file-renamer' ),
  UNIQUE_FILENAMES_DESCRIPTION: __( 'This will ensure that the filenames are unique. If a file with the same name already exists, it will be add a suffix to the filename to make it unique. You can choose between different methods.', 'media-file-renamer' ),

  UNIQUE_FILENAMES_NONE: __( 'None', 'media-file-renamer' ),
  UNIQUE_FILENAMES_NONE_DESCRIPTION: __( 'No unique filenames will be generated, files with existing names will be skipped.', 'media-file-renamer' ),
  UNIQUE_FILENAMES_INCREMENT: __( 'Increment', 'media-file-renamer' ),
  UNIQUE_FILENAMES_INCREMENT_DESCRIPTION: __( 'If a file with the same name already exists, it will append a number to the filename (myfile.jpg, myfile-2.jpg, myfile-3.jpg, etc).', 'media-file-renamer' ),
  UNIQUE_FILENAMES_HASH: __( 'Hash', 'media-file-renamer' ),
  UNIQUE_FILENAMES_HASH_DESCRIPTION: __( 'If a file with the same name already exists, it will append a hash to the filename (myfile.jpg, myfile-2f3g4h5i6j7k8l9m.jpg, etc). This is useful if you want to keep the original filename but still ensure uniqueness.', 'media-file-renamer' ),
  UNIQUE_FILENAMES_RANDOM: __( 'Random', 'media-file-renamer' ),
  UNIQUE_FILENAMES_RANDOM_DESCRIPTION: __( 'If a file with the same name already exists, it will append a random string to the filename (myfile.jpg, myfile-abc123.jpg, myfile-def456.jpg, etc). This is useful if you want to keep the original filename but still ensure uniqueness.', 'media-file-renamer' ),

  NUMBERED_FILES_LABEL: __( 'Enable Numbering', 'media-file-renamer' ),
  NUMBERED_FILES_DESCRIPTION: __( 'Identical filenames will be allowed by the plugin and a number will be appended automatically (myfile.jpg, myfile-2.jpg, myfile-3.jpg, etc).', 'media-file-renamer' ),
  FILENAME_PREFIX: __( 'Filename Prefix', 'media-file-renamer' ),
  FILENAME_SUFFIX: __( 'Filename Suffix', 'media-file-renamer' ),
  FILENAME_REPLACE: __( 'Filename Replace', 'media-file-renamer' ),
  FILENAME_REPLACE_DESCRIPTION: __( 'Enter the string to replace followed by an arrow "=>" and the string to replace with. Example: neko=>cat. Separate multiple replacements with a comma.', 'media-file-renamer' ),
  SYNCHRONIZE: __( 'Synchronize', 'media-file-renamer' ),
  TEST_RULES: __( 'Test Rules', 'media-file-renamer' ),
  GENERATE: __( 'Generate', 'media-file-renamer' ),
  APPLY_OR_CANCEL: __( 'Apply or Cancel', 'media-file-renamer' ),
  APPLY_OR_CANCEL_DESCRIPTION: __( 'This will ask you to apply or cancel the proposed changes, if you have the manual renaming enabled this leave you the chance to review the changes before applying them.', 'media-file-renamer' ),

  CLEAN_RENAME_ON_UPLOAD: __( 'The original filename will be cleaned and used as the new filename.', 'media-file-renamer' ),
  CLEAN_EXIF_TITLE_ON_UPLOAD: __( 'The EXIF Title will be cleaned and used as the new filename.', 'media-file-renamer' ),
  WRITE_USING_EXIF_TITLE: __( 'Replace by the EXIF Title.', 'media-file-renamer' ),
  WRITE_USING_FILENAME: __( 'Replace by the filename.', 'media-file-renamer' ),
  WRITE_USING_MEDIA_TITLE: __( 'Replace by the Media Title.', 'media-file-renamer' ),
  WRITE_USING_ALT_TEXT: __( 'Replace by the ALT Text.', 'media-file-renamer' ),
  WRITE_USING_POST_TITLE: __( 'Replace by the Post Title.', 'media-file-renamer' ),
  WRITE_USING_POST_ACF_FIELD: __( 'Replace by the Post ACF Field.', 'media-file-renamer' ),
  WRITE_USING_AI_VISION: __( 'Replace by the AI Vision\'s suggestion.', 'media-file-renamer' ),
  WRITE_USING_ATTACHED_POST_TITLE: __( 'Replace by the Attached Post Title.', 'media-file-renamer' ),
  WRITE_USING_MD5: __( 'Replace by the MD5 used by the filename.', 'media-file-renamer' ),

  ALT_TEXT: __( 'ALT Text', 'media-file-renamer' ),
  FILENAME_DESCRIPTION: __( 'The filename will be adapted based on the selected method.', 'media-file-renamer' ),
  PHP_ERROR_LOGS: __( 'PHP Error Logs', 'media-file-renamer' ),
  PHP_ERROR_LOGS_DESCRIPTION: __( 'The logs will also be written in the PHP error logs.', 'media-file-renamer' ),
  LOGS: __( 'Logs', 'media-file-renamer' ),
  LOGS_DESCRIPTION: __( 'Simple logging that explains which actions has been run.', 'media-file-renamer' ),
  REFRESH_LOGS: __( 'Refresh Logs', 'media-file-renamer' ),
  CLEAR_LOGS: __( 'Clear Logs', 'media-file-renamer' ),
  SQL_LOGS: __( 'SQL Logs', 'media-file-renamer' ),
  SQL_LOGS_DESCRIPTION: __( 'The files sql.log and sql_revert.log will be created under the log\'s directory and will include the raw SQL queries which were run by the plugin. If there is an issue, the revert SQL file can help you.', 'media-file-renamer' ),
  GUID: __( 'GUID', 'media-file-renamer' ),
  GUID_DESCRIPTION: __( 'The GUID will be renamed like the new filename. Better to keep this un-checked.', 'media-file-renamer' ),
  CASE_INSENSITIVE: __( 'Case Insensitive', 'media-file-renamer' ),
  CASE_INSENSITIVE_DESCRIPTION: __( 'This will consider the file such as "abc.jpg" and "ABC.JPG" as the same file. More information <a target="_blank" href="https://meowapps.com/media-file-renamer-faq-issues/">here</a>. You should check this if you are on a Windows-based server.', 'media-file-renamer' ),
  ENABLE_UNSAFE: __( 'Enable (Unsafe)', 'media-file-renamer' ),
  RENAME_ON_POST_SAVE: __( 'Rename on Post Save', 'media-file-renamer' ),
  RENAME_ON_POST_SAVE_DESCRIPTION: __( "You can modify the titles of your media while editing a post but, of course, the plugin can't update the HTML at this stage. With this option, the plugin will update the filenames and HTML after that you saved the post.", 'media-file-renamer' ),
  DELETE_ALL: __( 'Delete all', 'media-file-renamer' ),
  PLUGIN_DATA: __( 'Plugin Data', 'media-file-renamer' ),
  PLUGIN_DATA_DESCRIPTION: __( "The database and all the options of the plugin will be removed on uninstall. This also includes the information about the plugin's trash.", 'media-file-renamer' ),
  DELAY: __( 'Delay (in ms)', 'media-file-renamer' ),
  DELAY_DESCRIPTION: __( "Time to wait between each request (in milliseconds). The overall process is intensive so this gives the chance to your server to chill out a bit. A very good server doesn't need it, but a slow/shared hosting might even reject requests if they are too fast and frequent. Recommended value is actually 0, 100 for safety, 2000 or 5000 if your hosting is kind of cheap.", 'media-file-renamer' ),
  AUTOMATIC_RENAME: __( 'After Automatic Rename', 'media-file-renamer' ),
  AUTOMATIC_RENAME_DESCRIPTION: __( 'This is disabled by default; your media will be always renamed when needed.', 'media-file-renamer' ),
  MANUAL_RENAME: __( 'After Manual Rename', 'media-file-renamer' ),
  MANUAL_RENAME_DESCRIPTION: __( 'This is enabled by default; when you rename a media manually, it normally means that you want to fix the filename by yourself.', 'media-file-renamer' ),
  LOCK: __( 'Lock', 'media-file-renamer' ),
  HIDE_LOCKED: __( 'Hide Locked', 'media-file-renamer' ),
  HIDE_LOCKED_DESCRIPTION: __( 'Hide the locked files in the Dashboard tabs ( They will be visible only in the Locked section ).', 'media-file-renamer' ),
  RESET_METADATA: __( 'Reset Metadata', 'media-file-renamer' ),
  RESET_OPTIONS: __( 'Reset Options', 'media-file-renamer' ),
  EXPORT_OPTIONS: __( 'Export Options', 'media-file-renamer' ),
  IMPORT_OPTIONS: __( 'Import Options', 'media-file-renamer' ),
  UI: __( 'UI', 'media-file-renamer' ),
  AI_ENGINE_REQUIRED: __( "<a href='https://wordpress.org/plugins/ai-engine/' target='_blank'>AI Engine</a> needs to be installed. It's free!", 'media-file-renamer' ),
  AI_ENGINE_INSTALLED: __( "AI Engine", 'media-file-renamer' ),
  ALT_FIELD: __( 'ALT Field', 'media-file-renamer' ),
  ALT_FIELD_DESCRIPTION: __( 'An edit icon will be added, and will allow you to edit the Alternative Text.', 'media-file-renamer' ),
  ATTACHED_TO: __( 'Attached To', 'media-file-renamer' ),
  ATTACHED_TO_DESCRIPTION: __( 'An \'Attached To\' column will be displayed.', 'media-file-renamer' ),
  MEDIA_LIBRARY: __( 'Media Library', 'media-file-renamer' ),
  MEDIA_LIBRARY_FIELD_DESCRIPTION: __( 'Display of the features in the Media Library.', 'media-file-renamer' ),
  HISTORY_DESCRIPTION: __( 'The History column will be added to the dashboard table.', 'media-file-renamer' ),
  HISTORY_LIMIT: __( 'History Limit', 'media-file-renamer' ),
  HISTORY_LIMIT_DESCRIPTION: __( 'The number of entries to keep in the History column.', 'media-file-renamer' ),
  SYNC_DESCRIPTION: __( 'Description', 'media-file-renamer' ),
  SYNC_CAPTION: __( 'Caption', 'media-file-renamer' ),
  DISABLE_MANUAL_SYNC: __( 'Manual Sync', 'media-file-renamer' ),
  DISABLE_MANUAL_SYNC_DESCRIPTION: __( 'When you rename a file the plugin will automatically sync the fields you have enabled in "Fields Syncing". If you want to disable this behavior when manually renaming, check this option.', 'media-file-renamer' ),
  EXPORT_SETTINGS_ERROR: __( 'Error while exporting settings. Please check your console.', 'media-file-renamer' ),
  IMPORT_SETTINGS_SUCCESS: __( 'Settings imported. The page will now reload to reflect the changes.', 'media-file-renamer' ),
  IMPORT_SETTINGS_ERROR: __( 'Error while importing settings. Please check your console.', 'media-file-renamer' ),
  SCOPE: __( 'Scope', 'media-file-renamer' ),
  RULES: __( 'Rules', 'media-file-renamer' ),
  NO_FIELDS_SELECTED: __( '⚠️ No fields selected.', 'media-file-renamer' ),
  HIDE_NONE_WARNING: __( 'Hide "No Method" Warning', 'media-file-renamer' ),
  HIDE_NONE_WARNING_DESCRIPTION: __( 'Hide the warning that appears when you try to auto rename a file without any method selected.', 'media-file-renamer' ),
  TRIGGER_ON_ATTACHMENT_UPDATE: __( 'Trigger on Attachment Update', 'media-file-renamer' ),
  TRIGGER_ON_ATTACHMENT_UPDATE_DESCRIPTION: __( 'When an attachment is updated, the plugin will trigger the renaming process.', 'media-file-renamer' ),
};

i18n.ON_UPLOAD_OPTIONS = {
  NONE: __( 'None', 'media-file-renamer' ),
  VISION: __( 'AI Vision', 'media-file-renamer' ),
  CLEAN: __( 'Clean Upload', 'media-file-renamer' ),
  EXIF: __( 'EXIF Title', 'media-file-renamer' ),

  CLEAN_UPLOAD: __( 'Clean Upload', 'media-file-renamer' ),
  EXIF_UPLOAD: __( 'EXIF Upload', 'media-file-renamer' ),
  VISION_UPLOAD: __( 'Vision Upload', 'media-file-renamer' ),
};

i18n.ON_UPLOAD_DESCRIPTIONS = {
  NONE: __( 'Nothing will be done on upload.', 'media-file-renamer' ),
  UPLOAD_VISION: __( 'Generate metadata with AI Vision. It increases processing times.', 'media-file-renamer' ),
  UPLOAD_CLEAN: __( 'Generate metadata based on a refined filename.', 'media-file-renamer' ),
  UPLOAD_EXIF: __( 'Rename files with their EXIF titles, if present.', 'media-file-renamer' ),
};

export default i18n;

